#ifndef __DM_TJI_H__
#define __DM_TJI_H__

#include "dm_nutypedefs.h"

#ifdef __cplusplus
extern "C" {
#endif

#define DM_TJI_ANALOG_JOIN_BYTES      4
#define DM_TJI_DIGITAL_JOIN_BYTES     2

//Define TJI Level 6 Flags
#define FIRST_FLAG_ACTIVE 8
#define LAST_FLAG_ACTIVE  4 

extern INT32 JoinMonitorSlotCmd(UINT32 argc, char * cmd);
extern INT32 JoinGetInAnalogCmd(UINT32 argc, char * cmd);
extern INT32 JoinGetInDigitalCmd(UINT32 argc, char * cmd);
extern INT32 JoinGetInSerialCmd(UINT32 argc, char * cmd);
extern INT32 JoinGetOutAnalogCmd(UINT32 argc, char * cmd);
extern INT32 JoinGetOutDigitalCmd(UINT32 argc, char * cmd);
extern INT32 JoinGetOutSerialCmd(UINT32 argc, char * cmd);
extern INT32 JoinSetAnalogCmd(UINT32 argc, char * cmd);
extern INT32 JoinSetDigitalCmd(UINT32 argc, char * cmd);
extern INT32 JoinSetSerialCmd(UINT32 argc, char * cmd);

void ProcessResponseTJI( UINT8 subType, UINT8 bFlag, UINT8 transID, UINT8* pData, UINT8* pJoinHeader,
                         UINT32 dataCount, BOOL bMore, UINT8 bDestination, UINT8 bStream, BOOL rtji = 0);

void SendResponseTJI( UINT8 *pBegin, UINT8 count , BOOL rtji);

typedef void (*PRTJMONITOR_PENDING_DIGITAL_FUNC)(void* pDigitalList, UINT16 bListCount, UINT8 bStream);
extern PRTJMONITOR_PENDING_DIGITAL_FUNC pfRTJIDigitalPending;

typedef void (*PRTJMONITOR_PENDING_ANALOG_FUNC)(void* pAnalogList, UINT16 bListCount, UINT8 bStream);
extern PRTJMONITOR_PENDING_ANALOG_FUNC pfRTJIAnalogPending;

typedef void (*PRTJIMONITOR)(UINT8 subType, UINT8 bStream, UINT32 join, UINT32 value);
extern PRTJIMONITOR pfRTJIMonitor;

typedef UINT8 (*PTJISET)(UINT8 subType, char *SubSlot, UINT16 join, UINT32 value);
extern PTJISET pfTJISetDownStream;
typedef UINT8 (*PTJIGET)(UINT8 subType, char *SubSlot, UINT8 reqID, char *pBuffer, UINT8 length);
extern PTJIGET pfTJIGetDownStream;
#ifdef __cplusplus
}
#endif

#endif  //__DM_TJI_H__
